package com.bycom.versapro.MenuTypes.RSS.Adapters;


import static com.bycom.versapro.MenuTypes.WordPress.Adapters.WPPostAdapter.ITEM_BANNER_AD;

import android.content.Intent;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.RecyclerView;

import com.bycom.versapro.MenuTypes.WordPress.Adapters.WPPostAdapter;
import com.bycom.versapro.R;
import com.bycom.versapro.MenuTypes.RSS.UserInterface.RSSFeedDetailsFragment;
import com.bycom.versapro.MenuTypes.RSS.Serializables.RSSItem;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;


public class RSSAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {


    public static final int ITEM_RSS = 1;

    AppCompatActivity activity;
    public ArrayList<RSSItem> rssItems;

    Fragment fragment;




    public RSSAdapter(AppCompatActivity activity, Fragment fragment,ArrayList<RSSItem> rssItems) {

        this.activity = activity;
        this.rssItems = rssItems;
        this.fragment = fragment;


    }



    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {


        LayoutInflater inflater = LayoutInflater.from(activity);
        if (viewType == ITEM_RSS) {
            View view = inflater.inflate(R.layout.item_rss_feed, parent, false);
            return new RSSViewHolder(view);
        }
        if(viewType == ITEM_BANNER_AD){
            View view = inflater.inflate(R.layout.item_banner_ad, parent, false);
            return new WPPostAdapter.BannerAdViewHolder(view);
        }



        throw new IllegalArgumentException("Invalid view type");




    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {

        RSSItem rssItem = rssItems.get(position);

        if(viewHolder instanceof RSSViewHolder holder) {


            DisplayMetrics displayMetrics = holder.itemView.getContext().getResources().getDisplayMetrics();


            if(!rssItem.getThumbnailUrl().isEmpty()){
                holder.iv_post.setVisibility(View.VISIBLE);
                Picasso.get()
                        .load(rssItem.getThumbnailUrl())
                        .resize(displayMetrics.widthPixels,displayMetrics.heightPixels)
                        .centerInside()
                        .into(holder.iv_post);
            }else holder.iv_post.setVisibility(View.GONE);



            if(!rssItem.getAuthor().isEmpty()) {
                holder.tv_author.setVisibility(View.VISIBLE);
                holder.tv_author.setText(rssItem.getAuthor());
            }else holder.tv_author.setVisibility(View.GONE);



            holder.tv_title.setText(rssItem.getTitle());



            if(!rssItem.getViews().isEmpty()) {
                String sb = rssItem.getDate() +
                        " • " +
                        rssItem.getViews() +
                        " " +
                        activity.getString(R.string.views_label);
                holder.tv_date.setText(sb);
            }else  holder.tv_date.setText(rssItem.getDate());


            holder.itemView.setOnClickListener(view -> {

                if(rssItem.getLink().contains("youtube")) {


                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(rssItem.getLink()));
                    intent.setPackage("com.google.android.youtube");
                    try {
                        activity.startActivity(intent);
                    } catch (Exception e) {
                        intent.setPackage(null);
                        activity.startActivity(intent);
                    }




                }else {


                    FragmentTransaction transaction = activity.getSupportFragmentManager().beginTransaction();
                    RSSFeedDetailsFragment rssFeedDetailsFragment = new RSSFeedDetailsFragment(activity, rssItem);

                    transaction.hide(fragment);
                    transaction.add(R.id.container, rssFeedDetailsFragment);
                    transaction.addToBackStack(null);

                    transaction.commit();

                }

            });



        }

        if(viewHolder instanceof WPPostAdapter.BannerAdViewHolder holder){



                holder.banner_ad_container.removeAllViews();


                if (rssItem.getAdView().getParent() != null) {
                    ((ViewGroup) rssItem.getAdView().getParent()).removeView(rssItem.getAdView());
                }

                holder.banner_ad_container.addView(rssItem.getAdView());

         


        }


    }







    @Override
    public int getItemViewType(int position) {
        return rssItems.get(position).getType();
    }



    @Override
    public int getItemCount() {
        return rssItems.size();
    }

    public static class RSSViewHolder extends RecyclerView.ViewHolder {

        ImageView iv_post;

        TextView tv_title;

        TextView tv_date,tv_author;



        public RSSViewHolder(@NonNull View itemView) {
            super(itemView);


            iv_post = itemView.findViewById(R.id.iv_post);
            tv_title = itemView.findViewById(R.id.tv_title);
            tv_date = itemView.findViewById(R.id.tv_date);
            tv_author = itemView.findViewById(R.id.tv_author);



        }
    }






}
